package gov.va.med.mhv.sm.webservice.util;

import java.util.Date;

import gov.va.med.mhv.foundation.util.DescriptionBuilder;
import gov.va.med.mhv.sm.util.UserUtils;
import gov.va.med.mhv.sm.webservice.mhvauthentication.AdministratorAuthenticationRequest;
import gov.va.med.mhv.sm.webservice.mhvauthentication.AdministratorAuthenticationSubject;
import gov.va.med.mhv.sm.webservice.mhvauthentication.AuthenticationCredentials;
import gov.va.med.mhv.sm.webservice.mhvauthentication.Facility;
import gov.va.med.mhv.sm.webservice.mhvauthentication.PatientAuthenticationRequest;
import gov.va.med.mhv.sm.webservice.mhvauthentication.PatientAuthenticationSubject;

import org.apache.axis.types.NormalizedString;
import org.apache.axis.types.Token;
import org.apache.commons.lang.StringUtils;

public class MHVAuthenticationUtils {

	public static String describe(AdministratorAuthenticationRequest request) {
		StringBuilder builder = new StringBuilder();
		builder.append("AdministratorAuthenticationRequest[");
		if (request == null) {
			builder.append("NULL");
		} else {
			builder.append("credentials=").append(describe(request.
				getCredentials()));
			builder.append("; data=").append(describe(request.getData()));
		}
		builder.append("]");
		return builder.toString();
	}

	public static String describe(PatientAuthenticationRequest request) {
		StringBuilder builder = new StringBuilder();
		builder.append("PatientAuthenticationRequest[");
		if (request == null) {
			builder.append("NULL");
		} else {
			builder.append("credentials=").append(describe(request.
				getCredentials()));
			builder.append("; data=").append(describe(request.getData()));
		}
		builder.append("]");
		return builder.toString();
	}
	
	public static String toString(Facility facility) {
		if (facility == null) {
			return null;
		}
		final boolean hasStationNumber = (facility.getStationNumber() != null);
		return (hasStationNumber ? facility.getStationNumber() : "") + 
			((facility.getName() != null) 
			 ? ((hasStationNumber) ? "^" : "") + facility.getName() : "");  
	}

	public static String[] toString(Facility[] facilities) {
		final int length = (facilities != null) ? facilities.length : 0;
		String[] facilityStrings = new String[length];
		for (int i = 0; i < length; i++) {
			facilityStrings[i] = toString(facilities[i]);
		}
		return facilityStrings;
	}

	public static String toString(NormalizedString string) {
		return (string != null) ? string.toString() : null; 
	}

	public static Token toToken(String value) {
		return (value != null) ? new Token(value) : null; 
	}

	private static String describe(AuthenticationCredentials credentials) {
		StringBuilder builder = new StringBuilder();
		builder.append("Credentials[");
		if (credentials == null) {
			builder.append("NULL");
		} else {
			builder.append("source=").append(credentials.getSource());
			builder.append("; key=").append(mask(credentials.getKey()));
			if (credentials.getExpires() != null) {
				builder.append("; expires=").append(describe(new Date(
					credentials.getExpires().getTimeInMillis())));
			}
		}
		builder.append("]");
		return builder.toString();
	}

	private static String describe(AdministratorAuthenticationSubject subject) {
		StringBuilder builder = new StringBuilder();
		builder.append("AdminSubject[");
		if (subject == null) {
			builder.append("NULL");
		} else {
			builder.append("userName=").append(toString(subject.getUserName()));
			builder.append("; firstName=").append(toString(subject.
				getFirstName()));
			builder.append("; lastName=").append(toString(subject.
				getLastName()));
			builder.append("; facilities=").append(describe(toString(subject.
				getFacilities())));
			builder.append("; visns=").append(describe(toString(subject.
					getVisns())));
			builder.append("; national=").append(subject.isNational());
		}
		builder.append("]");
		return builder.toString();
	}

	private static String describe(PatientAuthenticationSubject subject) {
		StringBuilder builder = new StringBuilder();
		builder.append("PatientSubject[");
		if (subject == null) {
			builder.append("NULL");
		} else {
			builder.append("userName=").append(toString(subject.getUserName()));
			builder.append("; firstName=").append(toString(subject.
				getFirstName()));
			builder.append("; lastName=").append(toString(subject.
				getLastName()));
			builder.append("; dob=").append(describe(subject.getDob()));
			builder.append("; ssn=").append(UserUtils.maskSsn(toString(subject.
				getSsn())));
			builder.append("; icn=").append(UserUtils.maskIcn(toString(subject.
				getIcn())));
			builder.append("; facilities=").append(describe(toString(subject.
				getFacilities())));
			builder.append("; authenticated=").append(subject.
				isAuthenticated());
		}
		builder.append("]");
		return builder.toString();
	}

	private static String toString(Token token) {
		return (token != null) ? token.toString() : null;
	}

	private static String mask(Token token) {
		if (token == null) {
			return null;
		}
		String value = token.toString();
		if (value == null) {
			return null;
		}
		return StringUtils.repeat("*", value.length());
	}
	
	private static String describe(String[] values) {
		return DescriptionBuilder.describe(values);
	}

	private static String describe(Date value) {
		return DescriptionBuilder.describe(value);
	}

	private MHVAuthenticationUtils() {
	}

}
